(function (angular) {
    'use strict';
    // angular.module('FileManagerApp').config(['$translateProvider', function ($translateProvider) {
    angular.module('angularApp').config(['$translateProvider', function ($translateProvider) {
        $translateProvider.useSanitizeValueStrategy(null);

        $translateProvider.translations('en', {
            filemanager: 'File Manager',
            language: 'Language',
            english: 'English',
            spanish: 'Spanish',
            portuguese: 'Portuguese',
            french: 'French',
            german: 'German',
            hebrew: 'Hebrew',
            italian: 'Italian',
            slovak: 'Slovak',
            chinese_tw: 'Traditional Chinese',
            chinese_cn: 'Simple Chinese',
            russian: 'Russian',
            ukrainian: 'Ukrainian',
            turkish: 'Turkish',
            persian: 'Persian',
            polish: 'Polish',
            dutch:  'Dutch',
            confirm: 'Confirm',
            cancel: 'Cancel',
            close: 'Close',
            upload_files: 'Upload files',
            files_will_uploaded_to: 'Files will be uploaded to',
            select_files: 'Select files',
            uploading: 'Uploading',
            permissions: 'Permissions',
            select_destination_folder: 'Select the destination folder',
            source: 'Source',
            destination: 'Destination',
            copy_file: 'Copy file',
            sure_to_delete: 'Are you sure to delete',
            change_name_move: 'Change name / move',
            enter_new_name_for: 'Enter new name for',
            extract_item: 'Extract item',
            extraction_started: 'Extraction started in a background process',
            compression_started: 'Compression started in a background process',
            enter_folder_name_for_extraction: 'Enter the folder name for the extraction of',
            enter_file_name_for_compression: 'Enter the file name for the compression of',
            toggle_fullscreen: 'Toggle fullscreen',
            edit_file: 'Edit file',
            file_content: 'File content',
            loading: 'Loading',
            search: 'Search',
            create_folder: 'Create folder',
            create: 'Create',
            folder_name: 'Folder name',
            upload: 'Upload',
            change_permissions: 'Change permissions',
            change: 'Change',
            details: 'Details',
            icons: 'Icons',
            list: 'List',
            name: 'Name',
            size: 'Size',
            actions: 'Actions',
            date: 'Date',
            selection: 'Selection',
            no_files_in_folder: 'No files in this folder',
            no_folders_in_folder: 'This folder not contains children folders',
            select_this: 'Select this',
            go_back: 'Go back',
            wait: 'Wait',
            move: 'Move',
            download: 'Download',
            view_item: 'View item',
            remove: 'Delete',
            edit: 'Edit',
            copy: 'Copy',
            rename: 'Rename',
            extract: 'Extract',
            compress: 'Compress',
            error_invalid_filename: 'Invalid filename or already exists, specify another name',
            error_modifying: 'An error occurred modifying the file',
            error_deleting: 'An error occurred deleting the file or folder',
            error_renaming: 'An error occurred renaming the file',
            error_copying: 'An error occurred copying the file',
            error_compressing: 'An error occurred compressing the file or folder',
            error_extracting: 'An error occurred extracting the file',
            error_creating_folder: 'An error occurred creating the folder',
            error_getting_content: 'An error occurred getting the content of the file',
            error_changing_perms: 'An error occurred changing the permissions of the file',
            error_uploading_files: 'An error occurred uploading files',
            sure_to_start_compression_with: 'Are you sure to compress',
            owner: 'Owner',
            group: 'Group',
            others: 'Others',
            read: 'Read',
            write: 'Write',
            exec: 'Exec',
            original: 'Original',
            changes: 'Changes',
            recursive: 'Recursive',
            preview: 'Item preview',
            open: 'Open',
            these_elements: 'these {{total}} elements',
            new_folder: 'New folder',
            download_as_zip: 'Download as ZIP'
        });

        $translateProvider.translations('nl', {
            filemanager: 'Bestand beheerder',
            language: 'Taal',
            english: 'Engels',
            spanish: 'Spaans',
            portuguese: 'Portugees',
            french: 'Frans',
            german: 'Duits',
            hebrew: 'Hebrews',
            slovak: 'Slowakije',
            chinese: 'Chinees',
            russian: 'Russisch',
            ukrainian: 'Oekraïens',
            turkish: 'Turks',
            persian: 'Perzisch',
            confirm: 'Bevestigen',
            cancel: 'Annuleren',
            close: 'Sluiten',
            upload_files: 'Bestanden uploaden',
            files_will_uploaded_to: 'Bestanden worden geüpload naar',
            select_files: 'Selecteer bestanden',
            uploading: 'Uploaden',
            permissions: 'Rechten',
            select_destination_folder: 'Selecteer de map van bestemming',
            source: 'Bron',
            destination: 'Doel',
            copy_file: 'Kopieer bestand',
            sure_to_delete: 'Weet je zeker dat je wilt verwijderen',
            change_name_move: 'Hernoemen / verplaatsen',
            enter_new_name_for: 'Typ een nieuwe naam voor',
            extract_item: 'Uitpakken',
            extraction_started: 'Uitpakken gestart als achtergrond proces',
            compression_started: 'Inpakken gestart als achtergrond proces',
            enter_folder_name_for_extraction: 'Typ een map naar voor het uitpakken van',
            enter_file_name_for_compression: 'Typ een bestandsnaam voor het inpakken van',
            toggle_fullscreen: 'Volledigscherm',
            edit_file: 'Bewerk bestand',
            file_content: 'Bestandsinhoud',
            loading: 'Laden',
            search: 'Zoeken',
            create_folder: 'Maak map',
            create: 'Maak',
            folder_name: 'Map naam',
            upload: 'Uploaden',
            change_permissions: 'Rechten aanpassen',
            change: 'Aanpassen',
            details: 'Details',
            icons: 'Iconen',
            list: 'Lijst',
            name: 'Naam',
            size: 'Grootte',
            actions: 'Acties',
            date: 'Datum',
            no_files_in_folder: 'Geen bestanden in deze map',
            no_folders_in_folder: 'Deze map bevat geen submappen',
            select_this: 'Selecteer dit',
            go_back: 'Ga terug',
            wait: 'Wacht',
            move: 'Verplaats',
            download: 'Download',
            view_item: 'Bekijk item',
            remove: 'Verwijderen',
            edit: 'Bewerken',
            copy: 'Kopiëren',
            rename: 'Hernoemen',
            extract: 'Uitpakken',
            compress: 'Inpakken',
            error_invalid_filename: 'Ongeldige bestandsnaam of bestand al aanwezig, kies een andere naam',
            error_modifying: 'Er is een fout opgetreden met het bewerken van het bestand',
            error_deleting: 'Er is een fout opgetreden tijdens het verwijderen van de bestand of map',
            error_renaming: 'Er is een fout opgetreden tijdens het hernoemen van het bestand',
            error_copying: 'Er is een fout opgetreden tijdens het kopiëren van het bestand',
            error_compressing: 'Er is een fout opgetreden tijdens het inpakken van het bestand of map',
            error_extracting: 'Er is een fout opgetreden tijdens het uitpakken van het bestand',
            error_creating_folder: 'Er is een fout opgetreden tijdens het maken van de map',
            error_getting_content: 'Er is een fout opgetreden tijdens het ophalen van de inhoud van het bestand',
            error_changing_perms: 'Er is een fout opgetreden tijdens het aanpassen van de rechten van het bestand',
            error_uploading_files: 'Er is een fout opgetreden tijdens het uploaden van de bestanden',
            sure_to_start_compression_with: 'Weet je zeker dat je dit wilt inpakken',
            owner: 'Eigenaar',
            group: 'Groep',
            others: 'Andere',
            read: 'Lees',
            write: 'Schrijf',
            exec: 'Uitvoeren',
            original: 'Origineel',
            changes: 'Aanpassingen',
            recursive: 'Recursieve',
            preview: 'Item bekijken',
            open: 'Openen',
            these_elements: 'Deze {{total}} elementen',
            new_folder: 'Nieuwe map',
            download_as_zip: 'Download als ZIP'
        });

        $translateProvider.translations('he', {
            filemanager: 'מנהל קבצים',
            language: 'שפה',
            english: 'אנגלית',
            spanish: 'ספרדית',
            portuguese: 'פורטוגזית',
            french: 'צרפתית',
            german: 'גרמנית',
            hebrew: 'עברי',
            italian: 'איטלקי',
            slovak: 'סלובקי',
            chinese_tw: 'סינית מסורתית',
            chinese_cn: 'סינית פשוטה',
            russian: 'רוּסִי',
            ukrainian: 'אוקראיני',
            turkish: 'טורקי',
            persian: 'פַּרסִית',
            polish: 'פולני',
            confirm: 'אשר',
            cancel: 'בטל',
            close: 'סגור',
            upload_files: 'העלה קבצים',
            files_will_uploaded_to: 'הקבצים יעלו ל',
            select_files: 'בחר קבצים',
            uploading: 'מעלה',
            permissions: 'הרשאות',
            select_destination_folder: 'בחר תיקיית יעד',
            source: 'מקור',
            destination: 'יעד',
            copy_file: 'העתק קובץ',
            sure_to_delete: 'האם אתה בטוח שברצונך למחוק',
            change_name_move: 'שנה שם / הזז',
            enter_new_name_for: 'הקלד שם חדש עבור',
            extract_item: 'חלץ פריט',
            extraction_started: 'תהליך החילוץ מתבצע ברקע',
            compression_started: 'תהליך הכיווץ מתבצע ברקע',
            enter_folder_name_for_extraction: 'הקלד שם תיקייה לחילוץ עבור',
            enter_file_name_for_compression: 'הזן את שם הקובץ עבור הדחיסה של',
            toggle_fullscreen: 'הפעל/בטל מסך מלא',
            edit_file: 'ערוך קובץ',
            file_content: 'תוכן הקובץ',
            loading: 'טוען',
            search: 'חפש',
            create_folder: 'צור תיקייה',
            create: 'צור',
            folder_name: 'שם תיקייה',
            upload: 'העלה',
            change_permissions: 'שנה הרשאות',
            change: 'שנה',
            details: 'פרטים',
            icons: 'סמלים',
            list: 'רשימה',
            name: 'שם',
            size: 'גודל',
            actions: 'פעולות',
            date: 'תאריך',
            selection: 'בְּחִירָה',
            no_files_in_folder: 'אין קבצים בתיקייה זו',
            no_folders_in_folder: 'התיקייה הזו אינה כוללת תתי תיקיות',
            select_this: 'בחר את זה',
            go_back: 'חזור אחורה',
            wait: 'חכה',
            move: 'הזז',
            download: 'הורד',
            view_item: 'הצג פריט',
            remove: 'מחק',
            edit: 'ערוך',
            copy: 'העתק',
            rename: 'שנה שם',
            extract: 'חלץ',
            compress: 'כווץ',
            error_invalid_filename: 'שם קובץ אינו תקין או קיים, ציין שם קובץ אחר',
            error_modifying: 'התרחשה שגיאה בעת שינוי הקובץ',
            error_deleting: 'התרחשה שגיאה בעת מחיקת הקובץ או התיקייה',
            error_renaming: 'התרחשה שגיאה בעת שינוי שם הקובץ',
            error_copying: 'התרחשה שגיאה בעת העתקת הקובץ',
            error_compressing: 'התרחשה שגיאה בעת כיווץ הקובץ או התיקייה',
            error_extracting: 'התרחשה שגיאה בעת חילוץ הקובץ או התיקייה',
            error_creating_folder: 'התרחשה שגיאה בעת יצירת התיקייה',
            error_getting_content: 'התרחשה שגיאה בעת בקשת תוכן הקובץ',
            error_changing_perms: 'התרחשה שגיאה בעת שינוי הרשאות הקובץ',
            error_uploading_files: 'התרחשה שגיאה בעת העלאת הקבצים',
            sure_to_start_compression_with: 'האם אתה בטוח שברצונך לכווץ',
            owner: 'בעלים',
            group: 'קבוצה',
            others: 'אחרים',
            read: 'קריאה',
            write: 'כתיבה',
            exec: 'הרצה',
            original: 'מקורי',
            changes: 'שינויים',
            recursive: 'רקורסיה',
            preview: 'הצגת פריט',
            open: 'פתח',
            new_folder: 'תיקיה חדשה',
            download_as_zip: 'להוריד כמו'
        });

        $translateProvider.translations('pt', {
            filemanager: 'Gerenciador de arquivos',
            language: 'Língua',
            english: 'Inglês',
            spanish: 'Espanhol',
            portuguese: 'Portugues',
            french: 'Francês',
            german: 'Alemão',
            hebrew: 'Hebraico',
            italian: 'Italiano',
            slovak: 'Eslovaco',
            chinese_tw: 'Tradicional Chinesa',
            chinese_cn: 'Chinês Simplificado',
            russian: 'Russo',
            ukrainian: 'Ucraniano',
            turkish: 'Turco',
            persian: 'Persa',
            polish: 'Polonês',
            confirm: 'Confirmar',
            cancel: 'Cancelar',
            close: 'Fechar',
            upload_files: 'Carregar arquivos',
            files_will_uploaded_to: 'Os arquivos serão enviados para',
            select_files: 'Selecione os arquivos',
            uploading: 'Carregar',
            permissions: 'Autorizações',
            select_destination_folder: 'Selecione a pasta de destino',
            source: 'Origem',
            destination: 'Destino',
            copy_file: 'Copiar arquivo',
            sure_to_delete: 'Tem certeza de que deseja apagar',
            change_name_move: 'Renomear / mudança',
            enter_new_name_for: 'Digite o novo nome para',
            extract_item: 'Extrair arquivo',
            extraction_started: 'A extração começou em um processo em segundo plano',
            compression_started: 'A compressão começou em um processo em segundo plano',
            enter_folder_name_for_extraction: 'Digite o nome da pasta para a extração de',
            enter_file_name_for_compression: 'Digite o nome do arquivo para a compressão de',
            toggle_fullscreen: 'Ativar/desativar tela cheia',
            edit_file: 'Editar arquivo',
            file_content: 'Conteúdo do arquivo',
            loading: 'Carregando',
            search: 'Localizar',
            create_folder: 'Criar Pasta',
            create: 'Criar',
            folder_name: 'Nome da pasta',
            upload: 'Fazer',
            change_permissions: 'Alterar permissões',
            change: 'Alterar',
            details: 'Detalhes',
            icons: 'Icones',
            list: 'Lista',
            name: 'Nome',
            size: 'Tamanho',
            actions: 'Ações',
            date: 'Data',
            selection: 'Seleção',
            no_files_in_folder: 'Não há arquivos nesta pasta',
            no_folders_in_folder: 'Esta pasta não contém subpastas',
            select_this: 'Selecione esta',
            go_back: 'Voltar',
            wait: 'Espere',
            move: 'Mover',
            download: 'Baixar',
            view_item: 'Veja o arquivo',
            remove: 'Excluir',
            edit: 'Editar',
            copy: 'Copiar',
            rename: 'Renomear',
            extract: 'Extrair',
            compress: 'Comprimir',
            error_invalid_filename: 'Nome do arquivo inválido ou nome de arquivo já existe, especifique outro nome',
            error_modifying: 'Ocorreu um erro ao modificar o arquivo',
            error_deleting: 'Ocorreu um erro ao excluir o arquivo ou pasta',
            error_renaming: 'Ocorreu um erro ao mudar o nome do arquivo',
            error_copying: 'Ocorreu um erro ao copiar o arquivo',
            error_compressing: 'Ocorreu um erro ao comprimir o arquivo ou pasta',
            error_extracting: 'Ocorreu um erro ao extrair o arquivo',
            error_creating_folder: 'Ocorreu um erro ao criar a pasta',
            error_getting_content: 'Ocorreu um erro ao obter o conteúdo do arquivo',
            error_changing_perms: 'Ocorreu um erro ao alterar as permissões do arquivo',
            error_uploading_files: 'Ocorreu um erro upload de arquivos',
            sure_to_start_compression_with: 'Tem certeza que deseja comprimir',
            owner: 'Proprietário',
            group: 'Grupo',
            others: 'Outros',
            read: 'Leitura',
            write: 'Escrita ',
            exec: 'Execução',
            original: 'Original',
            changes: 'Mudanças',
            recursive: 'Recursiva',
            preview: 'Visualização',
            open: 'Abrir',
            these_elements: 'estes {{total}} elements',
            new_folder: 'Nova pasta',
            download_as_zip: 'Download como ZIP'
        });

        $translateProvider.translations('es', {
            filemanager: 'Administrador de archivos',
            language: 'Idioma',
            english: 'Ingles',
            spanish: 'Español',
            portuguese: 'Portugues',
            french: 'Francés',
            german: 'Alemán',
            hebrew: 'Hebreo',
            italian: 'Italiano',
            slovak: 'Eslovaco',
            chinese_tw: 'Tradicional China',
            chinese_cn: 'Chino Simplificado',
            russian: 'Ruso',
            ukrainian: 'Ucraniano',
            turkish: 'Turco',
            persian: 'Persa',
            polish: 'Polaco',
            confirm: 'Confirmar',
            cancel: 'Cancelar',
            close: 'Cerrar',
            upload_files: 'Subir archivos',
            files_will_uploaded_to: 'Los archivos seran subidos a',
            select_files: 'Seleccione los archivos',
            uploading: 'Subiendo',
            permissions: 'Permisos',
            select_destination_folder: 'Seleccione la carpeta de destino',
            source: 'Origen',
            destination: 'Destino',
            copy_file: 'Copiar archivo',
            sure_to_delete: 'Esta seguro que desea eliminar',
            change_name_move: 'Renombrar / mover',
            enter_new_name_for: 'Ingrese el nuevo nombre para',
            extract_item: 'Extraer archivo',
            extraction_started: 'La extraccion ha comenzado en un proceso de segundo plano',
            compression_started: 'La compresion ha comenzado en un proceso de segundo plano',
            enter_folder_name_for_extraction: 'Ingrese el nombre de la carpeta para la extraccion de',
            enter_file_name_for_compression: 'Ingrese el nombre del archivo para la compresion de',
            toggle_fullscreen: 'Activar/Desactivar pantalla completa',
            edit_file: 'Editar archivo',
            file_content: 'Contenido del archivo',
            loading: 'Cargando',
            search: 'Buscar',
            create_folder: 'Crear carpeta',
            create: 'Crear',
            folder_name: 'Nombre de la carpeta',
            upload: 'Subir',
            change_permissions: 'Cambiar permisos',
            change: 'Cambiar',
            details: 'Detalles',
            icons: 'Iconos',
            list: 'Lista',
            name: 'Nombre',
            size: 'Tamaño',
            actions: 'Acciones',
            date: 'Fecha',
            selection: 'Selección',
            no_files_in_folder: 'No hay archivos en esta carpeta',
            no_folders_in_folder: 'Esta carpeta no contiene sub-carpetas',
            select_this: 'Seleccionar esta',
            go_back: 'Volver',
            wait: 'Espere',
            move: 'Mover',
            download: 'Descargar',
            view_item: 'Ver archivo',
            remove: 'Eliminar',
            edit: 'Editar',
            copy: 'Copiar',
            rename: 'Renombrar',
            extract: 'Extraer',
            compress: 'Comprimir',
            error_invalid_filename: 'El nombre del archivo es invalido o ya existe',
            error_modifying: 'Ocurrio un error al intentar modificar el archivo',
            error_deleting: 'Ocurrio un error al intentar eliminar el archivo',
            error_renaming: 'Ocurrio un error al intentar renombrar el archivo',
            error_copying: 'Ocurrio un error al intentar copiar el archivo',
            error_compressing: 'Ocurrio un error al intentar comprimir el archivo',
            error_extracting: 'Ocurrio un error al intentar extraer el archivo',
            error_creating_folder: 'Ocurrio un error al intentar crear la carpeta',
            error_getting_content: 'Ocurrio un error al obtener el contenido del archivo',
            error_changing_perms: 'Ocurrio un error al cambiar los permisos del archivo',
            error_uploading_files: 'Ocurrio un error al subir archivos',
            sure_to_start_compression_with: 'Esta seguro que desea comprimir',
            owner: 'Propietario',
            group: 'Grupo',
            others: 'Otros',
            read: 'Lectura',
            write: 'Escritura',
            exec: 'Ejecucion',
            original: 'Original',
            changes: 'Cambios',
            recursive: 'Recursivo',
            preview: 'Vista previa',
            open: 'Abrir',
            these_elements: 'estos {{total}} elementos',
            new_folder: 'Nueva carpeta',
            download_as_zip: 'Descargar como ZIP'
        });

        $translateProvider.translations('fr', {
            filemanager: 'Gestionnaire de fichier',
            language: 'Langue',
            english: 'Anglais',
            spanish: 'Espagnol',
            portuguese: 'Portugais',
            french: 'Français',
            german: 'Allemand',
            hebrew: 'Hébreu',
            italian: 'Italien',
            slovak: 'Slovaque',
            chinese_tw: 'Traditionnelle Chinoise',
            chinese_cn: 'Chinois Simplifié',
            russian: 'Russe',
            ukrainian: 'Ukrainien',
            turkish: 'Turc',
            persian: 'Persan',
            polish: 'Polonais',
            confirm: 'Confirmer',
            cancel: 'Annuler',
            close: 'Fermer',
            upload_files: 'Télécharger des fichiers',
            files_will_uploaded_to: 'Les fichiers seront uploadé dans',
            select_files: 'Sélectionnez les fichiers',
            uploading: 'Upload en cours',
            permissions: 'Permissions',
            select_destination_folder: 'Sélectionné le dossier de destination',
            source: 'Source',
            destination: 'Destination',
            copy_file: 'Copier le fichier',
            sure_to_delete: 'Êtes-vous sûr de vouloir supprimer',
            change_name_move: 'Renommer / Déplacer',
            enter_new_name_for: 'Entrer le nouveau nom pour',
            extract_item: 'Extraires les éléments',
            extraction_started: 'L\'extraction a démarré en tâche de fond',
            compression_started: 'La compression a démarré en tâche de fond',
            enter_folder_name_for_extraction: 'Entrer le nom du dossier pour l\'extraction de',
            enter_file_name_for_compression: 'Entrez le nom de fichier pour la compression de',
            toggle_fullscreen: 'Basculer en plein écran',
            edit_file: 'Éditer le fichier',
            file_content: 'Contenu du fichier',
            loading: 'Chargement en cours',
            search: 'Recherche',
            create_folder: 'Créer un dossier',
            create: 'Créer',
            folder_name: 'Nom du dossier',
            upload: 'Upload',
            change_permissions: 'Changer les permissions',
            change: 'Changer',
            details: 'Details',
            icons: 'Icons',
            list: 'Liste',
            name: 'Nom',
            size: 'Taille',
            actions: 'Actions',
            date: 'Date',
            selection: 'Sélection',
            no_files_in_folder: 'Aucun fichier dans ce dossier',
            no_folders_in_folder: 'Ce dossier ne contiens pas de dossier',
            select_this: 'Sélectionner',
            go_back: 'Retour',
            wait: 'Patienter',
            move: 'Déplacer',
            download: 'Télécharger',
            view_item: 'Voir l\'élément',
            remove: 'Supprimer',
            edit: 'Éditer',
            copy: 'Copier',
            rename: 'Renommer',
            extract: 'Extraire',
            compress: 'Compresser',
            error_invalid_filename: 'Nom de fichier invalide ou déjà existant, merci de spécifier un autre nom',
            error_modifying: 'Une erreur est survenue pendant la modification du fichier',
            error_deleting: 'Une erreur est survenue pendant la suppression du fichier ou du dossier',
            error_renaming: 'Une erreur est survenue pendant le renommage du fichier',
            error_copying: 'Une erreur est survenue pendant la copie du fichier',
            error_compressing: 'Une erreur est survenue pendant la compression du fichier ou du dossier',
            error_extracting: 'Une erreur est survenue pendant l\'extraction du fichier',
            error_creating_folder: 'Une erreur est survenue pendant la création du dossier',
            error_getting_content: 'Une erreur est survenue pendant la récupération du contenu du fichier',
            error_changing_perms: 'Une erreur est survenue pendant le changement des permissions du fichier',
            error_uploading_files: 'Une erreur est survenue pendant l\'upload des fichiers',
            sure_to_start_compression_with: 'Êtes-vous sûre de vouloir compresser',
            owner: 'Propriétaire',
            group: 'Groupe',
            others: 'Autres',
            read: 'Lecture',
            write: 'Écriture',
            exec: 'Éxécution',
            original: 'Original',
            changes: 'Modifications',
            recursive: 'Récursif',
            preview: 'Aperçu',
            open: 'Ouvrir',
            these_elements: 'ces {{total}} éléments',
            new_folder: 'Nouveau dossier',
            download_as_zip: 'Télécharger comme ZIP'
        });

        $translateProvider.translations('de', {
            filemanager: 'Dateimanager',
            language: 'Sprache',
            english: 'Englisch',
            spanish: 'Spanisch',
            portuguese: 'Portugiesisch',
            french: 'Französisch',
            german: 'Deutsch',
            hebrew: 'Hebräisch',
            italian: 'Italienisch',
            slovak: 'Slowakisch',
            chinese_tw: 'Traditionelles Chinesisch',
            chinese_cn: 'Vereinfachtes Chinesisch',
            russian: 'Russisch',
            ukrainian: 'Ukrainisch',
            turkish: 'Türkisch',
            persian: 'Persisch',
            polish: 'Polnisch',
            confirm: 'Bestätigen',
            cancel: 'Abbrechen',
            close: 'Schließen',
            upload_files: 'Hochladen von Dateien',
            files_will_uploaded_to: 'Dateien werden hochgeladen nach',
            select_files: 'Wählen Sie die Dateien',
            uploading: 'Lade hoch',
            permissions: 'Berechtigungen',
            select_destination_folder: 'Wählen Sie einen Zielordner',
            source: 'Quelle',
            destination: 'Ziel',
            copy_file: 'Datei kopieren',
            sure_to_delete: 'Sind Sie sicher, dass Sie die Datei löschen möchten?',
            change_name_move: 'Namen ändern / verschieben',
            enter_new_name_for: 'Geben Sie den neuen Namen ein für',
            extract_item: 'Archiv entpacken',
            extraction_started: 'Entpacken hat im Hintergrund begonnen',
            compression_started: 'Komprimierung hat im Hintergrund begonnen',
            enter_folder_name_for_extraction: 'Geben Sie den Verzeichnisnamen für die Entpackung an von',
            enter_file_name_for_compression: 'Geben Sie den Dateinamen für die Kompression an von',
            toggle_fullscreen: 'Vollbild umschalten',
            edit_file: 'Datei bearbeiten',
            file_content: 'Dateiinhalt',
            loading: 'Lade',
            search: 'Suche',
            create_folder: 'Ordner erstellen',
            create: 'Erstellen',
            folder_name: 'Verzeichnisname',
            upload: 'Hochladen',
            change_permissions: 'Berechtigungen ändern',
            change: 'Ändern',
            details: 'Details',
            icons: 'Symbolansicht',
            list: 'Listenansicht',
            name: 'Name',
            size: 'Größe',
            actions: 'Aktionen',
            date: 'Datum',
            selection: 'Auswahl',
            no_files_in_folder: 'Keine Dateien in diesem Ordner',
            no_folders_in_folder: 'Dieser Ordner enthält keine Unterordner',
            select_this: 'Auswählen',
            go_back: 'Zurück',
            wait: 'Warte',
            move: 'Verschieben',
            download: 'Herunterladen',
            view_item: 'Datei ansehen',
            remove: 'Löschen',
            edit: 'Bearbeiten',
            copy: 'Kopieren',
            rename: 'Umbenennen',
            extract: 'Entpacken',
            compress: 'Komprimieren',
            error_invalid_filename: 'Ungültiger Dateiname oder existiert bereits',
            error_modifying: 'Beim Bearbeiten der Datei ist ein Fehler aufgetreten',
            error_deleting: 'Beim Löschen der Datei oder des Ordners ist ein Fehler aufgetreten',
            error_renaming: 'Beim Umbennenen der Datei ist ein Fehler aufgetreten',
            error_copying: 'Beim Kopieren der Datei ist ein Fehler aufgetreten',
            error_compressing: 'Beim Komprimieren der Datei oder des Ordners ist ein Fehler aufgetreten',
            error_extracting: 'Beim Entpacken der Datei ist ein Fehler aufgetreten',
            error_creating_folder: 'Beim Erstellen des Ordners ist ein Fehler aufgetreten',
            error_getting_content: 'Beim Laden des Dateiinhalts ist ein Fehler aufgetreten',
            error_changing_perms: 'Beim Ändern der Dateiberechtigungen ist ein Fehler aufgetreten',
            error_uploading_files: 'Beim Hochladen der Dateien ist ein Fehler aufgetreten',
            sure_to_start_compression_with: 'Möchten Sie die Datei wirklich komprimieren?',
            owner: 'Besitzer',
            group: 'Gruppe',
            others: 'Andere',
            read: 'Lesen',
            write: 'Schreiben',
            exec: 'Ausführen',
            original: 'Original',
            changes: 'Änderungen',
            recursive: 'Rekursiv',
            preview: 'Dateivorschau',
            open: 'Öffnen',
            these_elements: 'diese {{total}} elemente',
            new_folder: 'Neuer ordner',
            download_as_zip: 'Download als ZIP'
        });

        $translateProvider.translations('sk', {
            filemanager: 'Správca súborov',
            language: 'Jazyk',
            english: 'Angličtina',
            spanish: 'Španielčina',
            portuguese: 'Portugalčina',
            french: 'Francúzština',
            german: 'Nemčina',
            hebrew: 'Hebrejčina',
            italian: 'Italština',
            slovak: 'Slovenčina',
            chinese_tw: 'Tradičná Čínska',
            chinese_cn: 'Zjednodušená Čínština',
            russian: 'Ruský',
            ukrainian: 'Ukrajinský',
            turkish: 'Turecký',
            persian: 'Perzský',
            polish: 'Poľský',
            confirm: 'Potvrdiť',
            cancel: 'Zrušiť',
            close: 'Zavrieť',
            upload_files: 'Nahrávať súbory',
            files_will_uploaded_to: 'Súbory budú nahrané do',
            select_files: 'Vybrať súbory',
            uploading: 'Nahrávanie',
            permissions: 'Oprávnenia',
            select_destination_folder: 'Vyberte cieľový príečinok',
            source: 'Zdroj',
            destination: 'Cieľ',
            copy_file: 'Kopírovať súbor',
            sure_to_delete: 'Ste si istý, že chcete vymazať',
            change_name_move: 'Premenovať / Premiestniť',
            enter_new_name_for: 'Zadajte nové meno pre',
            extract_item: 'Rozbaliť položku',
            extraction_started: 'Rozbaľovanie začalo v procese na pozadí',
            compression_started: 'Kompresia začala v procese na pzoadí',
            enter_folder_name_for_extraction: 'Zadajte názov priečinka na rozbalenie',
            enter_file_name_for_compression: 'Zadajte názov súboru pre kompresiu',
            toggle_fullscreen: 'Prepnúť režim na celú obrazovku',
            edit_file: 'Upraviť súbor',
            file_content: 'Obsah súboru',
            loading: 'Načítavanie',
            search: 'Hľadať',
            create_folder: 'Vytvoriť priečinok',
            create: 'Vytvoriť',
            folder_name: 'Názov priećinka',
            upload: 'Nahrať',
            change_permissions: 'Zmeniť oprávnenia',
            change: 'Zmeniť',
            details: 'Podrobnosti',
            icons: 'Ikony',
            list: 'Zoznam',
            name: 'Meno',
            size: 'Veľkosť',
            actions: 'Akcie',
            date: 'Dátum',
            selection: 'Výber',
            no_files_in_folder: 'V tom to priečinku nie sú žiadne súbory',
            no_folders_in_folder: 'Tento priečinok neobsahuje žiadne ďalšie priećinky',
            select_this: 'Vybrať tento',
            go_back: 'Ísť späť',
            wait: 'Počkajte',
            move: 'Presunúť',
            download: 'Stiahnuť',
            view_item: 'Zobraziť položku',
            remove: 'Vymazať',
            edit: 'Upraviť',
            copy: 'Kopírovať',
            rename: 'Premenovať',
            extract: 'Rozbaliť',
            compress: 'Komprimovať',
            error_invalid_filename: 'Neplatné alebo duplicitné meno súboru, vyberte iné meno',
            error_modifying: 'Vyskytla sa chyba pri upravovaní súboru',
            error_deleting: 'Vyskytla sa chyba pri mazaní súboru alebo priečinku',
            error_renaming: 'Vyskytla sa chyba pri premenovaní súboru',
            error_copying: 'Vyskytla sa chyba pri kopírovaní súboru',
            error_compressing: 'Vyskytla sa chyba pri komprimovaní súboru alebo priečinka',
            error_extracting: 'Vyskytla sa chyba pri rozbaľovaní súboru',
            error_creating_folder: 'Vyskytla sa chyba pri vytváraní priečinku',
            error_getting_content: 'Vyskytla sa chyba pri získavaní obsahu súboru',
            error_changing_perms: 'Vyskytla sa chyba pri zmene oprávnení súboru',
            error_uploading_files: 'Vyskytla sa chyba pri nahrávaní súborov',
            sure_to_start_compression_with: 'Ste si istý, že chcete komprimovať',
            owner: 'Vlastník',
            group: 'Skupina',
            others: 'Ostatní',
            read: 'Čítanie',
            write: 'Zapisovanie',
            exec: 'Spúštanie',
            original: 'Originál',
            changes: 'Zmeny',
            recursive: 'Rekurzívne',
            preview: 'Náhľad položky',
            open: 'Otvoriť',
            these_elements: 'týchto {{total}} prvkov',
            new_folder: 'Nový priečinok',
            download_as_zip: 'Stiahnuť ako ZIP'
        });

        $translateProvider.translations('zh_cn', {
            filemanager: '文档管理器',
            language: '语言',
            english: '英语',
            spanish: '西班牙语',
            portuguese: '葡萄牙语',
            french: '法语',
            german: '德语',
            hebrew: '希伯来语',
            italian: '意大利',
            slovak: '斯洛伐克语',
            chinese_tw: '正体中文',
            chinese_cn: '简体中文',
            russian: '俄語',
            ukrainian: '烏克蘭',
            turkish: '土耳其',
            persian: '波斯語',
            polish: '波兰语',
            confirm: '确定',
            cancel: '取消',
            close: '关闭',
            upload_files: '上传文件',
            files_will_uploaded_to: '文件将上传到',
            select_files: '选择文件',
            uploading: '上传中',
            permissions: '权限',
            select_destination_folder: '选择目标文件',
            source: '源自',
            destination: '目的地',
            copy_file: '复制文件',
            sure_to_delete: '确定要删除？',
            change_name_move: '改名或移动？',
            enter_new_name_for: '输入新的名称',
            extract_item: '解压',
            extraction_started: '解压已经在后台开始',
            compression_started: '压缩已经在后台开始',
            enter_folder_name_for_extraction: '输入解压的目标文件夹',
            enter_file_name_for_compression: '输入要压缩的文件名',
            toggle_fullscreen: '切换全屏',
            edit_file: '编辑文件',
            file_content: '文件内容',
            loading: '加载中',
            search: '搜索',
            create_folder: '创建文件夹',
            create: '创建',
            folder_name: '文件夹名称',
            upload: '上传',
            change_permissions: '修改权限',
            change: '修改',
            details: '详细信息',
            icons: '图标',
            list: '列表',
            name: '名称',
            size: '尺寸',
            actions: '操作',
            date: '日期',
            selection: '选择',
            no_files_in_folder: '此文件夹没有文件',
            no_folders_in_folder: '此文件夹不包含子文件夹',
            select_this: '选择此文件',
            go_back: '后退',
            wait: '等待',
            move: '移动',
            download: '下载',
            view_item: '查看子项',
            remove: '删除',
            edit: '编辑',
            copy: '复制',
            rename: '重命名',
            extract: '解压',
            compress: '压缩',
            error_invalid_filename: '非法文件名或文件已经存在, 请指定其它名称',
            error_modifying: '修改文件出错',
            error_deleting: '删除文件或文件夹出错',
            error_renaming: '重命名文件出错',
            error_copying: '复制文件出错',
            error_compressing: '压缩文件或文件夹出错',
            error_extracting: '解压文件出错',
            error_creating_folder: '创建文件夹出错',
            error_getting_content: '获取文件内容出错',
            error_changing_perms: '修改文件权限出错',
            error_uploading_files: '上传文件出错',
            sure_to_start_compression_with: '确定要压缩？',
            owner: '拥有者',
            group: '群组',
            others: '其他',
            read: '读取',
            write: '写入',
            exec: '执行',
            original: '原始',
            changes: '变化',
            recursive: '递归',
            preview: '成员预览',
            open: '打开',
            these_elements: '共 {{total}} 个',
            new_folder: '新文件夹',
            download_as_zip: '下载的ZIP'
        });

        $translateProvider.translations('zh_tw', {
            filemanager: '檔案管理員',
            language: '語言',
            english: '英語',
            spanish: '西班牙語',
            portuguese: '葡萄牙語',
            french: '法語',
            german: '德語',
            hebrew: '希伯來語',
            italian: '意大利',
            slovak: '斯洛伐克語',
            chinese_tw: '正體中文',
            chinese_cn: '簡體中文',
            russian: '俄語',
            ukrainian: '烏克蘭',
            turkish: '土耳其',
            persian: '波斯語',
            polish: '波蘭語',
            confirm: '確定',
            cancel: '取消',
            close: '關閉',
            upload_files: '上傳檔案',
            files_will_uploaded_to: '檔案將上傳到',
            select_files: '選擇檔案',
            uploading: '上傳中',
            permissions: '權限',
            select_destination_folder: '選擇目標檔案',
            source: '來自',
            destination: '目的地',
            copy_file: '複製檔案',
            sure_to_delete: '確定要刪除？',
            change_name_move: '更名或移動？',
            enter_new_name_for: '輸入新的名稱',
            extract_item: '解壓',
            extraction_started: '解壓已經在後台開始',
            compression_started: '壓縮已經在後台開始',
            enter_folder_name_for_extraction: '輸入解壓的目標資料匣',
            enter_file_name_for_compression: '輸入要壓縮的檔名',
            toggle_fullscreen: '切換全螢幕',
            edit_file: '編輯檔案',
            file_content: '檔案內容',
            loading: '載入中',
            search: '尋找',
            create_folder: '建立資料匣',
            create: '建立',
            folder_name: '資料匣名稱',
            upload: '上傳',
            change_permissions: '修改權限',
            change: '修改',
            details: '詳細內容',
            icons: '圖示',
            list: '列表',
            name: '名稱',
            size: '大小',
            actions: '操作',
            date: '日期',
            selection: '選擇',
            no_files_in_folder: '此資料匣沒有文件',
            no_folders_in_folder: '此資料匣不包含子資料匣',
            select_this: '選擇此資料匣',
            go_back: '後退',
            wait: '等待',
            move: '移動',
            download: '下載',
            view_item: '檢視',
            remove: '刪除',
            edit: '存檔',
            copy: '複製',
            rename: '更改名稱',
            extract: '解壓',
            compress: '壓縮',
            error_invalid_filename: '非法檔名或檔案已經存在, 請指定其它檔名',
            error_modifying: '修改檔案出錯',
            error_deleting: '刪除檔案或資料夾出錯',
            error_renaming: '更改名稱發生出錯',
            error_copying: '複製檔案出錯',
            error_compressing: '壓縮檔案或資料匣出錯',
            error_extracting: '解壓檔案出錯',
            error_creating_folder: '建立資料匣出錯',
            error_getting_content: '獲取檔案內容出錯',
            error_changing_perms: '修改檔案權限出錯',
            error_uploading_files: '上傳檔案出錯',
            sure_to_start_compression_with: '確定要壓縮？',
            owner: '擁有者',
            group: '群組',
            others: '其他',
            read: '讀取',
            write: '寫入',
            exec: '執行',
            original: '現行',
            changes: '變更為',
            recursive: '包含所有子資料匣',
            preview: '預覽',
            open: '開啟',
            these_elements: '共 {{total}} 個',
            new_folder: '新資料匣',
            download_as_zip: '以ZIP下載'
        });

        $translateProvider.translations('ru', {
            filemanager: 'Файловый менеджер',
            language: 'Язык',
            english: 'Английский',
            spanish: 'Испанский',
            portuguese: 'Португальский',
            french: 'Французкий',
            german: 'Немецкий',
            hebrew: 'Хинди',
            italian: 'итальянский',
            slovak: 'Словацкий',
            chinese_tw: 'Традиционный Китайский',
            chinese_cn: 'Упрощенный Китайский',
            russian: 'русский',
            ukrainian: 'украинец',
            turkish: 'турецкий',
            persian: 'персидский',
            polish: 'Польский',
            confirm: 'Подьвердить',
            cancel: 'Отменить',
            close: 'Закрыть',
            upload_files: 'Загрузка файлов',
            files_will_uploaded_to: 'Файлы будут загружены в: ',
            select_files: 'Выберите файлы',
            uploading: 'Загрузка',
            permissions: 'Разрешения',
            select_destination_folder: 'Выберите папку назначения',
            source: 'Источкик',
            destination: 'Цель',
            copy_file: 'Скопировать файл',
            sure_to_delete: 'Действительно удалить?',
            change_name_move: 'Переименовать / переместить',
            enter_new_name_for: 'Новое имя для',
            extract_item: 'Извлечь',
            extraction_started: 'Извлечение начато',
            compression_started: 'Сжатие начато',
            enter_folder_name_for_extraction: 'Извлечь в укананную папку',
            enter_file_name_for_compression: 'Введите имя архива',
            toggle_fullscreen: 'На весь экран',
            edit_file: 'Редактировать',
            file_content: 'Содержимое файла',
            loading: 'Загрузка',
            search: 'Поиск',
            create_folder: 'Создать папку',
            create: 'Создать',
            folder_name: 'Имя папки',
            upload: 'Загрузить',
            change_permissions: 'Изменить разрешения',
            change: 'Изменить',
            details: 'Свойства',
            icons: 'Иконки',
            list: 'Список',
            name: 'Имя',
            size: 'Размер',
            actions: 'Действия',
            date: 'Дата',
            selection: 'выбор',
            no_files_in_folder: 'Пустая папка',
            no_folders_in_folder: 'Пустая папка',
            select_this: 'Выбрать',
            go_back: 'Назад',
            wait: 'Подождите',
            move: 'Переместить',
            download: 'Скачать',
            view_item: 'Отобразить содержимое',
            remove: 'Удалить',
            edit: 'Редактировать',
            copy: 'Скопировать',
            rename: 'Переименовать',
            extract: 'Извлечь',
            compress: 'Сжать',
            error_invalid_filename: 'Имя неверное или уже существует, выберите другое',
            error_modifying: 'Произошла ошибка при модифицировании файла',
            error_deleting: 'Произошла ошибка при удалении',
            error_renaming: 'Произошла ошибка при переименовании файла',
            error_copying: 'Произошла ошибка при копировании файла',
            error_compressing: 'Произошла ошибка при сжатии',
            error_extracting: 'Произошла ошибка при извлечении',
            error_creating_folder: 'Произошла ошибка при создании папки',
            error_getting_content: 'Произошла ошибка при получении содержимого',
            error_changing_perms: 'Произошла ошибка при изменении разрешений',
            error_uploading_files: 'Произошла ошибка при загрузке',
            sure_to_start_compression_with: 'Действительно сжать',
            owner: 'Владелец',
            group: 'Группа',
            others: 'Другие',
            read: 'Чтение',
            write: 'Запись',
            exec: 'Выполнение',
            original: 'По-умолчанию',
            changes: 'Изменения',
            recursive: 'Рекурсивно',
            preview: 'Просмотр',
            open: 'Открыть',
            these_elements: 'всего {{total}} елементов',
            new_folder: 'Новая папка',
            download_as_zip: 'Download as ZIP'
        });

        $translateProvider.translations('ua', {
            filemanager: 'Файловий менеджер',
            language: 'Мова',
            english: 'Англійська',
            spanish: 'Іспанська',
            portuguese: 'Португальська',
            french: 'Французька',
            german: 'Німецька',
            hebrew: 'Хінді',
            italian: 'італійський',
            slovak: 'Словацька',
            chinese_tw: 'традиційний Китайський',
            chinese_cn: 'Cпрощена Китайська',
            russian: 'російський',
            ukrainian: 'український',
            turkish: 'турецька',
            persian: 'перський',
            polish: 'Польська',
            confirm: 'Підтвердити',
            cancel: 'Відмінити',
            close: 'Закрити',
            upload_files: 'Завантаження файлів',
            files_will_uploaded_to: 'Файли будуть завантажені у: ',
            select_files: 'Виберіть файли',
            uploading: 'Завантаження',
            permissions: 'Дозволи',
            select_destination_folder: 'Виберіть папку призначення',
            source: 'Джерело',
            destination: 'Ціль',
            copy_file: 'Скопіювати файл',
            sure_to_delete: 'Дійсно удалить?',
            change_name_move: 'Перейменувати / перемістити',
            enter_new_name_for: 'Нове ім\'я для',
            extract_item: 'Извлечь',
            extraction_started: 'Извлечение начато',
            compression_started: 'Архівацію почато',
            enter_folder_name_for_extraction: 'Извлечь в укананную папку',
            enter_file_name_for_compression: 'Введите имя архива',
            toggle_fullscreen: 'На весь экран',
            edit_file: 'Редагувати',
            file_content: 'Вміст файлу',
            loading: 'Завантаження',
            search: 'Пошук',
            create_folder: 'Створити папку',
            create: 'Створити',
            folder_name: 'Ім\'я  папки',
            upload: 'Завантижити',
            change_permissions: 'Змінити дозволи',
            change: 'Редагувати',
            details: 'Властивості',
            icons: 'Іконки',
            list: 'Список',
            name: 'Ім\'я',
            size: 'Розмір',
            actions: 'Дії',
            date: 'Дата',
            selection: 'вибір',
            no_files_in_folder: 'Пуста папка',
            no_folders_in_folder: 'Пуста папка',
            select_this: 'Выбрати',
            go_back: 'Назад',
            wait: 'Зачекайте',
            move: 'Перемістити',
            download: 'Скачати',
            view_item: 'Показати вміст',
            remove: 'Видалити',
            edit: 'Редагувати',
            copy: 'Копіювати',
            rename: 'Переіменувати',
            extract: 'Розархівувати',
            compress: 'Архівувати',
            error_invalid_filename: 'Ім\'я певірне або вже існує, виберіть інше',
            error_modifying: 'Виникла помилка при редагуванні файлу',
            error_deleting: 'Виникла помилка при видаленні',
            error_renaming: 'Виникла помилка при зміні імені файлу',
            error_copying: 'Виникла помилка при коміюванні файлу',
            error_compressing: 'Виникла помилка при стисненні',
            error_extracting: 'Виникла помилка при розархівації',
            error_creating_folder: 'Виникла помилка при створенні папки',
            error_getting_content: 'Виникла помилка при отриманні вмісту',
            error_changing_perms: 'Виникла помилка при зміні дозволів',
            error_uploading_files: 'Виникла помилка при завантаженні',
            sure_to_start_compression_with: 'Дійсно стиснути',
            owner: 'Власник',
            group: 'Група',
            others: 'Інші',
            read: 'Читання',
            write: 'Запис',
            exec: 'Виконання',
            original: 'За замовчуванням',
            changes: 'Зміни',
            recursive: 'Рекурсивно',
            preview: 'Перегляд',
            open: 'Відкрити',
            these_elements: 'усього {{total}} елементів',
            new_folder: 'Нова папка',
            download_as_zip: 'Download as ZIP'
        });

        $translateProvider.translations('tr', {
            filemanager: 'Dosya Yöneticisi',
            language: 'Dil',
            english: 'İngilizce',
            spanish: 'İspanyolca',
            portuguese: 'Portekizce',
            french: 'Fransızca',
            german: 'Almanca',
            hebrew: 'İbranice',
            italian: 'İtalyanca',
            slovak: 'Slovakça',
            chinese_tw: 'Geleneksel Çin',
            chinese_cn: 'Basitleştirilmiş Çince',
            russian: 'Rusça',
            ukrainian: 'Ukraynaca',
            turkish: 'Türkçe',
            persian: 'Farsça',
            polish: 'Lehçe',
            confirm: 'Onayla',
            cancel: 'İptal Et',
            close: 'Kapat',
            upload_files: 'Dosya yükle',
            files_will_uploaded_to: 'Dosyalar yüklenecektir.',
            select_files: 'Dosya Seç',
            uploading: 'Yükleniyor',
            permissions: 'İzinler',
            select_destination_folder: 'Hedef klasör seçin',
            source: 'Kaynak',
            destination: 'Hedef',
            copy_file: 'Dosyayı kopyala',
            sure_to_delete: 'Silmek istediğinden emin misin',
            change_name_move: 'İsmini değiştir / taşı',
            enter_new_name_for: 'Yeni ad girin',
            extract_item: 'Dosya çıkar',
            extraction_started: 'Çıkarma işlemi arkaplanda devam ediyor',
            compression_started: 'Sıkıştırma işlemi arkaplanda başladı',
            enter_folder_name_for_extraction: 'Çıkarılması için klasör adı girin',
            enter_file_name_for_compression: 'Sıkıştırılması için dosya adı girin',
            toggle_fullscreen: 'Tam ekran moduna geç',
            edit_file: 'Dosyayı düzenle',
            file_content: 'Dosya içeriği',
            loading: 'Yükleniyor',
            search: 'Ara',
            create_folder: 'Klasör oluştur',
            create: 'Oluştur',
            folder_name: 'Klasör adı',
            upload: 'Yükle',
            change_permissions: 'İzinleri değiştir',
            change: 'Değiştir',
            details: 'Detaylar',
            icons: 'simgeler',
            list: 'Liste',
            name: 'Adı',
            size: 'Boyutu',
            actions: 'İşlemler',
            date: 'Tarih',
            selection: 'Seçim',
            no_files_in_folder: 'Klasörde hiç dosya yok',
            no_folders_in_folder: 'Bu klasör alt klasör içermez',
            select_this: 'Bunu seç',
            go_back: 'Geri git',
            wait: 'Bekle',
            move: 'Taşı',
            download: 'İndir',
            view_item: 'Dosyayı görüntüle',
            remove: 'Sil',
            edit: 'Düzenle',
            copy: 'Kopyala',
            rename: 'Yeniden Adlandır',
            extract: 'Çıkart',
            compress: 'Sıkıştır',
            error_invalid_filename: 'Geçersiz dosya adı, bu dosya adına sahip dosya mevcut',
            error_modifying: 'Dosya düzenlenirken bir hata oluştu',
            error_deleting: 'Klasör veya dosya silinirken bir hata oluştu',
            error_renaming: 'Dosya yeniden adlandırılırken bir hata oluştu',
            error_copying: 'Dosya kopyalanırken bir hata oluştu',
            error_compressing: 'Dosya veya klasör sıkıştırılırken bir hata oluştu',
            error_extracting: 'Çıkartılırken bir hata oluştu',
            error_creating_folder: 'Klasör oluşturulurken bir hata oluştu',
            error_getting_content: 'Dosya detayları alınırken bir hata oluştu',
            error_changing_perms: 'Dosyanın izini değiştirilirken bir hata oluştu',
            error_uploading_files: 'Dosyalar yüklenirken bir hata oluştu',
            sure_to_start_compression_with: 'Sıkıştırmak istediğinden emin misin',
            owner: 'Sahip',
            group: 'Grup',
            others: 'Diğerleri',
            read: 'Okuma',
            write: 'Yazma',
            exec: 'Gerçekleştir',
            original: 'Orjinal',
            changes: 'Değişiklikler',
            recursive: 'Yinemeli',
            preview: 'Dosyayı önizle',
            open: 'Aç',
            these_elements: '{{total}} eleman',
            new_folder: 'Yeni Klasör',
            download_as_zip: 'ZIP olarak indir'
        });

        $translateProvider.translations('fa', {
            filemanager: 'مدیریت فایل ها',
            language: 'زبان',
            english: 'انگلیسی',
            spanish: 'اسپانیایی',
            portuguese: 'پرتغالی',
            french: 'فرانسه',
            german: 'آلمانی',
            hebrew: 'عبری',
            italian: 'ایتالیایی',
            slovak: 'اسلواک',
            chinese_tw: 'چینی سنتی',
            chinese_cn: 'چینی ساده شده',
            russian: 'روسی',
            ukrainian: 'اوکراینی',
            turkish: 'ترکی',
            persian: 'فارسی',
            polish: 'لهستانی',
            confirm: 'تایید',
            cancel: 'رد',
            close: 'بستن',
            upload_files: 'آپلود فایل',
            files_will_uploaded_to: 'فایل ها آپلود می شوند به',
            select_files: 'انتخاب فایل ها',
            uploading: 'در حال آپلود',
            permissions: 'مجوز ها',
            select_destination_folder: 'پوشه مقصد را انتخاب کنید',
            source: 'مبدا',
            destination: 'مقصد',
            copy_file: 'کپی فایل',
            sure_to_delete: 'مطمين هستید می خواهید حذف کنید؟',
            change_name_move: 'تغییر نام و جابجایی',
            enter_new_name_for: 'نام جدیدی وارد کنید برای',
            extract_item: 'خارج کردن از حالت فشرده',
            extraction_started: 'یک پروسه در پس زمینه شروع به خارج کردن از حالت فشرده کرد',
            compression_started: 'یک پروسه در پس زمینه شروع به فشرده سازی کرد',
            enter_folder_name_for_extraction: 'نام پوشه مقصد برای خارج کردن از حالت فشرده را وارد کنید',
            enter_file_name_for_compression: 'نام پوشه مقصد برای فشرده سازی را وارد کنید',
            toggle_fullscreen: 'تعویض حالت تمام صفحه',
            edit_file: 'ویرایش',
            file_content: 'محتویات',
            loading: 'در حال بارگذاری',
            search: 'جستجو',
            create_folder: 'پوشه جدید',
            create: 'ساختن',
            folder_name: 'نام پوشه',
            upload: 'آپلود',
            change_permissions: 'تغییر مجوز ها',
            change: 'تغییر',
            details: 'جزییات',
            icons: 'آیکون ها',
            list: 'لیست',
            name: 'نام',
            size: 'سایز',
            actions: 'اعمال',
            date: 'تاریخ',
            selection: 'انتخاب',
            no_files_in_folder: 'هیچ فایلی در این پوشه نیست',
            no_folders_in_folder: 'هیچ پوشه ای داخل این پوشه قرار ندارد',
            select_this: 'انتخاب',
            go_back: 'بازگشت',
            wait: 'منتظر بمانید',
            move: 'جابجایی',
            download: 'دانلود',
            view_item: 'مشاهده این مورد',
            remove: 'حذف',
            edit: 'ویرایش',
            copy: 'کپی',
            rename: 'تغییر نام',
            extract: 'خروج از حالت فشرده',
            compress: 'فشرده سازی',
            error_invalid_filename: 'نام فایل مورد درست نیست و یا قبلا استفاده شده است، لطفا نام دیگری وارد کنید',
            error_modifying: 'در هنگام تغییر فایل خطایی پیش آمد',
            error_deleting: 'در هنگام حذف فایل خطایی پیش آمد',
            error_renaming: 'در هنگام تغییر نام فایل خطایی پیش آمد',
            error_copying: 'در هنگام کپی کردن فایل خطایی پیش آمد',
            error_compressing: 'در هنگام فشرده سازی فایل خطایی پیش آمد',
            error_extracting: 'در هنگام خارک کردن فایل از حالت فشرده خطایی پیش آمد',
            error_creating_folder: 'در هنگام ساخت پوشه خطایی پیش امد',
            error_getting_content: 'در هنگام بارگذاری محتویات فایل خطایی رخ داد',
            error_changing_perms: 'در هنگام تغییر مجوز های فایل خطایی رخ داد',
            error_uploading_files: 'در آپلود فایل خطایی رخ داد',
            sure_to_start_compression_with: 'مطمئن هستید فشرده سازی انجام شد؟',
            owner: 'مالک فایل',
            group: 'گروه',
            others: 'دیگران',
            read: 'خواندن',
            write: 'نوشتن',
            exec: 'اجرا کردن',
            original: 'اصلی',
            changes: 'تغییرات',
            recursive: 'بازگشتی',
            preview: 'پیش نمایش',
            open: 'باز کردن',
            these_elements: 'تعداد {{total}} مورد',
            new_folder: 'پوشه جدید',
            download_as_zip: 'به عنوان فایل فشرده دانلود شود'
        });

        $translateProvider.translations('pl', {
            filemanager: 'Menadżer plików',
            language: 'Język',
            english: 'Angielski',
            spanish: 'Hiszpański',
            portuguese: 'Portugalski',
            french: 'Francuski',
            german: 'Niemiecki',
            hebrew: 'Hebrajski',
            italian: 'Włoski',
            slovak: 'Słowacki',
            chinese_tw: 'Tradycyjny Chiński',
            chinese_cn: 'Chiński Uproszczony',
            russian: 'Rosyjski',
            ukrainian: 'Ukraiński',
            turkish: 'Turecki',
            persian: 'Perski',
            polish: 'Polski',
            confirm: 'Potwierdź',
            cancel: 'Anuluj',
            close: 'Zamknij',
            upload_files: 'Wgraj pliki',
            files_will_uploaded_to: 'Pliki będą umieszczone w katalogu',
            select_files: 'Wybierz pliki',
            uploading: 'Ładowanie',
            permissions: 'Uprawnienia',
            select_destination_folder: 'Wybierz folder docelowy',
            source: 'Źródło',
            destination: 'Cel',
            copy_file: 'Kopiuj plik',
            sure_to_delete: 'Jesteś pewien, że chcesz skasować',
            change_name_move: 'Zmień nazwę / przenieś',
            enter_new_name_for: 'Wpisz nową nazwę dla',
            extract_item: 'Rozpakuj element',
            extraction_started: 'Rozpakowywanie rozpoczęło się w tle',
            compression_started: 'Kompresowanie rozpoczęło się w tle',
            enter_folder_name_for_extraction: 'Wpisz nazwę folderu do rozpakowania',
            enter_file_name_for_compression: 'Wpisz nazwę folderu do skompresowania',
            toggle_fullscreen: 'Tryb pełnoekranowy',
            edit_file: 'Edytuj plik',
            file_content: 'Zawartość pliku',
            loading: 'Ładowanie',
            search: 'Szukaj',
            create_folder: 'Stwórz folder',
            create: 'Utwórz',
            folder_name: 'Nazwa folderu',
            upload: 'Wgraj',
            change_permissions: 'Zmień uprawnienia',
            change: 'Zmień',
            details: 'Szczegóły',
            icons: 'Ikony',
            list: 'Lista',
            name: 'Nazwa',
            size: 'Rozmiar',
            actions: 'Akcje',
            date: 'Data',
            selection: 'Zaznaczone',
            no_files_in_folder: 'Brak plików w tym folderze',
            no_folders_in_folder: 'Ten folder nie zawiera podfolderów',
            select_this: 'Wybierz ten',
            go_back: 'W górę',
            wait: 'Wait',
            move: 'Przenieś',
            download: 'Pobierz',
            view_item: 'Wyświetl',
            remove: 'Usuń',
            edit: 'Edycja',
            copy: 'Kopiuj',
            rename: 'Zmień nazwę',
            extract: 'Rozpakuj',
            compress: 'Skompresuj',
            error_invalid_filename: 'Błędna nazwa pliku lub plik o takiej nazwie już istnieje, proszę użyć innej nazwy',
            error_modifying: 'Wystąpił błąd podczas modyfikowania pliku',
            error_deleting: 'Wystąpił błąd podczas usuwania pliku lub folderu',
            error_renaming: 'Wystąpił błąd podczas zmiany nazwy pliku',
            error_copying: 'Wystąpił błąd podczas kopiowania pliku',
            error_compressing: 'Wystąpił błąd podczas kompresowania pliku lub folderu',
            error_extracting: 'Wystąpił błąd podczas rozpakowywania pliku',
            error_creating_folder: 'Wystąpił błąd podczas tworzenia nowego folderu',
            error_getting_content: 'Wystąpił błąd podczas pobierania zawartości pliku',
            error_changing_perms: 'Wystąpił błąd podczas zmiany uprawnień pliku',
            error_uploading_files: 'Wystąpił błąd podczas wgrywania plików',
            sure_to_start_compression_with: 'Jesteś pewien, że chcesz skompresować',
            owner: 'Właściciel',
            group: 'Grupa',
            others: 'Inni',
            read: 'Odczyt',
            write: 'Zapis',
            exec: 'Wykonywanie',
            original: 'Oryginał',
            changes: 'Zmiany',
            recursive: 'Rekursywnie',
            preview: 'Podgląd elementu',
            open: 'Otwórz',
            these_elements: 'te {{total}} elementy?',
            new_folder: 'Nowy folder',
            download_as_zip: 'Pobierz jako ZIP'
        });

        $translateProvider.translations('it', {
            filemanager: 'Gestore File',
            language: 'Lingua',
            english: 'Inglese',
            spanish: 'Spagnolo',
            portuguese: 'Portoghese',
            french: 'Francese',
            german: 'Tedesco',
            hebrew: 'Ebraico',
            slovak: 'Slovacco',
            chinese_tw: 'Cinese Tradizionale',
            chinese_cn: 'Cinese',
            russian: 'Russo',
            ukrainian: 'Ucraino',
            turkish: 'Turco',
            persian: 'Persiano',
            polish: 'Polacco',
            confirm: 'Conferma',
            cancel: 'Annulla',
            close: 'Chiudi',
            upload_files: 'Carica files',
            files_will_uploaded_to: 'I files saranno caricati in',
            select_files: 'Seleziona i files',
            uploading: 'Trasferimento',
            permissions: 'Permessi',
            select_destination_folder: 'Select carterlla di destinazione',
            source: 'Sorgente',
            destination: 'Destinazione',
            copy_file: 'Copia file',
            sure_to_delete: 'Sicuro di voler eliminare',
            change_name_move: 'Rinomina / sposta',
            enter_new_name_for: 'Inserisci nuovo nome per',
            extract_item: 'Estrai elemento',
            extraction_started: 'Decompressione avviata da un processo in background',
            compression_started: 'Compressione avviata da un processo in background',
            enter_folder_name_for_extraction: 'Inserisci nome cartella per l\'estrazione di',
            enter_file_name_for_compression: 'Inserisci nome file per la compressione di',
            toggle_fullscreen: 'Passa a schermo intero',
            edit_file: 'Modifica file',
            file_content: 'Contenuto del file',
            loading: 'Caricamento',
            search: 'Cerca',
            create_folder: 'Crea cartella',
            create: 'Crea',
            folder_name: 'Nome cartella',
            upload: 'Upload',
            change_permissions: 'Modifica permessi',
            change: 'Modifica',
            details: 'Dettagli',
            icons: 'Icone',
            list: 'Lista',
            name: 'Nome',
            size: 'Dimensione',
            actions: 'Azioni',
            date: 'Data',
            selection: 'Selezione',
            no_files_in_folder: 'Nessun file nella cartella',
            no_folders_in_folder: 'Questa cartella non contiene altre cartelle',
            select_this: 'Seleziona questo',
            go_back: 'Indietro',
            wait: 'Attendere',
            move: 'Sposta',
            download: 'Scarica',
            view_item: 'Visualizza elemento',
            remove: 'Elimina',
            edit: 'Modifica',
            copy: 'Copia',
            rename: 'Rinomina',
            extract: 'Estrai',
            compress: 'Comprimi',
            error_invalid_filename: 'Nome file non valido o già esistente, specificarne un\'altro',
            error_modifying: 'Errore durante la modifica del file',
            error_deleting: 'Errore durante l\'eliminazione del file o della cartella',
            error_renaming: 'Errore durante la rinomina del file',
            error_copying: 'Errore durante la copia del file',
            error_compressing: 'Errore durante la compressione del file o della cartella',
            error_extracting: 'Errore durante l\'estrazione del file',
            error_creating_folder: 'Errore nella creazione della cartella',
            error_getting_content: 'Errore nel recupero del contenuto del file',
            error_changing_perms: 'Errore durante la modifica dei permessi del file',
            error_uploading_files: 'Errore durante il trasferimento dei files',
            sure_to_start_compression_with: 'Sicuro di voler comprimere',
            owner: 'Proprietario',
            group: 'Gruppo',
            others: 'Altri',
            read: 'Lettura',
            write: 'Scrittura',
            exec: 'Esecuzione',
            original: 'Originario',
            changes: 'Cambiamenti',
            recursive: 'Ricorsivo',
            preview: 'Anteprima',
            open: 'Apri',
            these_elements: 'questi {{total}} elementi',
            new_folder: 'Nuova cartella',
            download_as_zip: 'Scarica come file ZIP'
        });

    }]);
})(angular);
